/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.app;

import CH.ifa.draw.figures.TextFigure;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.util.StorableInput;
import DE.siemens.ad.kop.app.KopEditorInfo;
import DE.siemens.ad.logo.app.ActionOwner;
import DE.siemens.ad.logo.app.ApplicationMenuManager;
import DE.siemens.ad.logo.app.ApplicationSurface;
import DE.siemens.ad.logo.app.AutoOpenFileThread;
import DE.siemens.ad.logo.app.Editor;
import DE.siemens.ad.logo.app.EditorInfo;
import DE.siemens.ad.logo.app.FileType;
import DE.siemens.ad.logo.app.MDIManager;
import DE.siemens.ad.logo.app.MDIMenuManager;
import DE.siemens.ad.logo.app.MenuManager;
import DE.siemens.ad.logo.app.Model;
import DE.siemens.ad.logo.app.View;
import DE.siemens.ad.logo.app.action.ActionFactory;
import DE.siemens.ad.logo.app.action.ActionGroup;
import DE.siemens.ad.logo.app.action.ActionManager;
import DE.siemens.ad.logo.app.action.CascadeAction;
import DE.siemens.ad.logo.app.action.LogoAction;
import DE.siemens.ad.logo.app.action.LogoJMenuBar;
import DE.siemens.ad.logo.app.action.OpenNamedDocumentAction;
import DE.siemens.ad.logo.app.action.ShowHelpContextAction;
import DE.siemens.ad.logo.app.comp.LogoFileChooser;
import DE.siemens.ad.logo.app.comp.RolloverButtonToolBar;
import DE.siemens.ad.logo.app.comp.SplittedDlg;
import DE.siemens.ad.logo.app.dialog.SelectDocumentToSaveControlPanel;
import DE.siemens.ad.logo.app.plaf.LookAndFeelLoader;
import DE.siemens.ad.logo.comm.Modem;
import DE.siemens.ad.logo.dialog.AboutPanel;
import DE.siemens.ad.logo.dialog.GetFileNamePanel;
import DE.siemens.ad.logo.dialog.SelectDocumentsToSavePanel;
import DE.siemens.ad.logo.dialog.comp.ProgressIndicator;
import DE.siemens.ad.logo.dialog.wizard.WizardDialog;
import DE.siemens.ad.logo.dialog.wizard.update.SelectModulesModel;
import DE.siemens.ad.logo.dialog.wizard.update.SelectUpdateDirectoryModel;
import DE.siemens.ad.logo.dialog.wizard.update.UpdateWizardModel;
import DE.siemens.ad.logo.model.Hardware;
import DE.siemens.ad.logo.model.WiringDiagram;
import DE.siemens.ad.logo.util.Global;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.Log;
import DE.siemens.ad.logo.util.LogoError;
import DE.siemens.ad.logo.util.LogoFileView;
import DE.siemens.ad.logo.util.LogoProperties;
import DE.siemens.ad.logo.util.ProgramException;
import DE.siemens.ad.logo.util.UntitledFile;
import DE.siemens.ad.logo.util.Util;
import DE.siemens.ad.logo.util.Version;
import DE.siemens.ad.pdraw.app.FupEditorInfo;
import DE.siemens.ad.pdraw.app.LogoComfort;
import DE.siemens.ad.pdraw.app.LogoHelp;
import DE.siemens.ad.pdraw.simulation.SimulationTool;
import DE.siemens.ad.pdraw.standard.LogoDrawing;
import DE.siemens.ad.udf.GuidVersionMgr;
import DE.siemens.ad.udf.LogoDrawingUDF;
import DE.siemens.ad.udf.LogoDrawingViewUDF;
import DE.siemens.ad.udf.UDFBlock;
import DE.siemens.ad.udf.UDFEditorInfo;
import DE.siemens.ad.udf.UDFFactory;
import DE.siemens.ad.udf.WiringDiagramUDF;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import javax.help.DefaultHelpBroker;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JToolBar;
import javax.swing.LookAndFeel;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.filechooser.FileSystemView;
import javax.swing.plaf.metal.MetalLookAndFeel;

public class Application
implements ActionOwner {
    public static final int YES = 0;
    public static final int NO = 1;
    public static final int QUERY = 2;
    protected static Process cHelpProcess = null;
    protected static final String OPEN_FILE_KEY = "openFile";
    protected static final String OPEN_FILE_ON_START_KEY = "app.saveWorkspace";
    protected static Application fSingletonInstance;
    protected MDIManager fMdiManager;
    private boolean fCtrlDown;
    private boolean fF4Down;
    protected UpdateWizardModel fUpdateWizardModel;
    protected MenuManager fMenuManager;
    public ActionFactory fActionFactory;
    protected ActionManager fActionManager;
    protected LogoFileChooser fFileChooser;
    protected Vector fAvailableMDIManagers;
    protected Vector fEditorInfos;
    protected Editor fDefaultEditor;

    private Application() {
        fSingletonInstance = this;
        try {
            LogoHelp.getHelpBroker();
        }
        catch (ProgramException e) {
            e.display(null, null);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        UDFFactory.instance().loadUDFProps();
        new Thread(){

            public void run() {
                Application.this.createFileChooser();
            }
        }.start();
        new Thread(){

            public void run() {
                SplittedDlg.getVirtualBounds();
            }
        }.start();
        this.getActiveApplicationSurface().setEditor(null);
        AWTEventListener awtEventListener = new AWTEventListener(){

            public void eventDispatched(AWTEvent event) {
                if (event instanceof KeyEvent) {
                    KeyEvent keyEvent = (KeyEvent)event;
                    Application.this.fCtrlDown = keyEvent.isControlDown();
                    Application.this.fF4Down = 115 == keyEvent.getKeyCode();
                }
            }
        };
        Toolkit.getDefaultToolkit().addAWTEventListener(awtEventListener, 8L);
    }

    public void addDocument(View view) {
        this.fMdiManager.addView(view);
        this.fMdiManager.changeToView(view);
    }

    public boolean closeAllViews() {
        ArrayList<View> modifiedViews = new ArrayList<View>();
        Iterator i = this.getMdiManager().getViews().iterator();
        View view = null;
        while (i.hasNext()) {
            view = (View)i.next();
            if (!view.getModel().isModified()) continue;
            modifiedViews.add(view);
        }
        Collection selectedViews = new ArrayList(5);
        if (!modifiedViews.isEmpty() && (!this.fCtrlDown || this.fCtrlDown && this.fF4Down)) {
            SelectDocumentsToSavePanel selectDocumentsPanel = new SelectDocumentsToSavePanel(modifiedViews);
            SplittedDlg dialog = SplittedDlg.create(this.getActiveApplicationSurface().getWindow(), selectDocumentsPanel, 0);
            dialog.setControlPanel(new SelectDocumentToSaveControlPanel(0));
            dialog.setTitle(Language.getStringNoTilde("file.closeAll", "Close all"));
            dialog.show();
            if (dialog.getControlPanel().getResult() == 2) {
                return false;
            }
            if (dialog.getControlPanel().getResult() == 128) {
                selectedViews = selectDocumentsPanel.getSelectedViews();
            }
        }
        this.fCtrlDown = false;
        this.fF4Down = false;
        Iterator views = new ArrayList(this.getMdiManager().getViews()).iterator();
        while (views.hasNext()) {
            int save = selectedViews.contains(view = (View)views.next()) ? 0 : 1;
            if (this.closeView(view, save) != 2) continue;
            return false;
        }
        return true;
    }

    public int closeView(View view, int save) {
        JToolBar toolBar;
        if (view.getModel().isModified()) {
            int saveRw;
            if (save == 2 && (!this.fCtrlDown || this.fCtrlDown && this.fF4Down)) {
                int saveRw2;
                int rw = JOptionPane.showConfirmDialog(this.getActiveApplicationSurface(), Language.getString("msg.saveDocument", "Document % changed. Save the changes?", view.getModel().getFile().getName()), Application.getName(), 1, 3);
                if (rw == 2) {
                    return rw;
                }
                if (rw == 0 && (saveRw2 = this.saveDocument(view)) == 1) {
                    return 2;
                }
            } else if (save == 0 && (saveRw = this.saveDocument(view)) == 1) {
                return 2;
            }
        }
        this.fCtrlDown = false;
        this.fF4Down = false;
        this.getMdiManager().removeView(view);
        JMenuBar menuBar = view.getEditor().getMenuManager().getMenuBar(null);
        if (menuBar instanceof LogoJMenuBar) {
            ((LogoJMenuBar)menuBar).unregisterMenuItemsForActions();
        }
        if ((toolBar = view.getEditor().getMenuManager().getToolBar(null)) instanceof RolloverButtonToolBar) {
            ((RolloverButtonToolBar)toolBar).unregisterToolbarItemsForActions();
        }
        view.getEditor().end();
        if (view instanceof DrawingView) {
            ((DrawingView)((Object)view)).setEditor(null);
        }
        return 0;
    }

    public Editor createEditor(String editorClassName) {
        try {
            Editor editor = (Editor)Class.forName(editorClassName).newInstance();
            editor.init(this);
            return editor;
        }
        catch (Exception e) {
            StringWriter stringWriter = new StringWriter();
            e.printStackTrace(new PrintWriter(stringWriter));
            JOptionPane.showMessageDialog(this.getActiveApplicationSurface(), Language.getString("error.creatingEditor", "Error while creating editor.") + "\n" + stringWriter);
            return null;
        }
    }

    public View createView(String editorClassName) {
        View view = null;
        Editor editor = this.createEditor(editorClassName);
        if (editor != null) {
            view = editor.newDocument();
        }
        return view;
    }

    public boolean exit() {
        this.exit(false);
        return true;
    }

    public boolean exit(boolean restart) {
        LogoProperties props;
        if (Modem.isModemConnected()) {
            Modem.getInstance().disconnectModem();
        }
        if ((props = LogoProperties.instance()).getBooleanProperty(OPEN_FILE_ON_START_KEY, true)) {
            int i = 0;
            for (View element : this.getMdiManager().getViews()) {
                File file = element.getModel().getFile();
                if (file instanceof UntitledFile) continue;
                props.setProperty(OPEN_FILE_KEY + i++, file.getAbsolutePath());
            }
            while (props.removePropertyKey(OPEN_FILE_KEY + i++) != null) {
            }
        }
        if (!this.fCtrlDown && !this.closeAllViews()) {
            return false;
        }
        this.getMdiManager().close();
        ((ApplicationMenuManager)this.getMenuManager()).getFileHistoryGroup().storeHistory();
        try {
            DefaultHelpBroker hb = LogoHelp.getHelpBroker();
            Dimension helpWindowSize = hb.getSize();
            Point pos = hb.getLocation();
            props.setProperty("helpWin.width", String.valueOf((int)helpWindowSize.getWidth()));
            props.setProperty("helpWin.height", String.valueOf((int)helpWindowSize.getHeight()));
            props.setProperty("helpWin.posX", String.valueOf((int)pos.getX()));
            props.setProperty("helpWin.posY", String.valueOf((int)pos.getY()));
        }
        catch (Exception e) {
            // empty catch block
        }
        String currentPath = this.getFileChooser().getCurrentDirectory().getPath();
        if (!currentPath.toLowerCase().startsWith("a:\\") && !currentPath.toLowerCase().startsWith("b:\\")) {
            props.setProperty("openSaveDir", currentPath);
        }
        props.setProperty("install.path", System.getProperty("user.dir"));
        props.setProperty("install.jar", "/lib/classes.jar");
        Version v = Version.getCurrentVersion();
        props.setProperty("install.version", v.getMajorVersion() + "." + v.getMinorVersion() + "." + v.getBuildVersion());
        props.saveProperties();
        if (this.fUpdateWizardModel != null) {
            this.fUpdateWizardModel.finishUpdate();
        }
        SplittedDlg.saveValues();
        if (restart) {
            try {
                String[] command = new String[]{"Start.exe"};
                Runtime.getRuntime().exec("Start.exe");
                System.out.println("Start again....");
            }
            catch (IOException e1) {
                System.err.println("if error=2 - this means teh program Start.exe was not found on path. Extend your path-variable to find Start.exe");
                e1.printStackTrace();
            }
        }
        System.exit(0);
        return true;
    }

    private Editor findEditor(File file) {
        FileType fileType;
        Iterator fileTypes;
        Vector editorInfos = this.getEditorInfos();
        EditorInfo foundEditor = null;
        Enumeration infos = editorInfos.elements();
        EditorInfo editorInfo = null;
        while (infos.hasMoreElements()) {
            editorInfo = (EditorInfo)infos.nextElement();
            if (!editorInfo.getDefaultFileType().accept(file)) continue;
            foundEditor = editorInfo;
            break;
        }
        if (foundEditor == null) {
            fileTypes = this.getDefaultEditor().getEditorInfo().getLoadableFileTypes().iterator();
            fileType = null;
            while (fileTypes.hasNext()) {
                fileType = (FileType)fileTypes.next();
                if (!fileType.accept(file)) continue;
                foundEditor = this.getDefaultEditor().getEditorInfo();
                break;
            }
        }
        if (foundEditor == null) {
            infos = editorInfos.elements();
            editorInfo = null;
            block2: while (infos.hasMoreElements()) {
                editorInfo = (EditorInfo)infos.nextElement();
                fileTypes = editorInfo.getLoadableFileTypes().iterator();
                fileType = null;
                while (fileTypes.hasNext()) {
                    fileType = (FileType)fileTypes.next();
                    if (!fileType.accept(file)) continue;
                    foundEditor = editorInfo;
                    continue block2;
                }
            }
        }
        if (foundEditor != null) {
            return this.createEditor(foundEditor.getEditorClassName());
        }
        return null;
    }

    public ActionFactory getActionFactory() {
        if (this.fActionFactory == null) {
            this.fActionFactory = new ActionFactory(this);
            this.fActionFactory.setActionPackage("DE.siemens.ad.logo.app.action.");
        }
        return this.fActionFactory;
    }

    public ActionManager getActionManager() {
        if (this.fActionManager == null) {
            this.fActionManager = new ActionManager(this);
        }
        return this.fActionManager;
    }

    public ApplicationSurface getActiveApplicationSurface() {
        return this.getMdiManager().getApplicationSurface();
    }

    public Vector getAvailableMDIManagers() {
        if (this.fAvailableMDIManagers == null) {
            this.fAvailableMDIManagers = new Vector();
            this.fAvailableMDIManagers.add("DE.siemens.ad.logo.app.InternalFrameMDIManager");
            this.fAvailableMDIManagers.add("DE.siemens.ad.logo.app.TabbedPaneMDIManager");
        }
        return this.fAvailableMDIManagers;
    }

    public Editor getDefaultEditor() {
        if (this.fDefaultEditor == null) {
            String firstEditorName = null;
            firstEditorName = this.getEditorInfos().size() > 0 ? ((EditorInfo)this.getEditorInfos().elementAt(0)).getEditorClassName() : "DE.siemens.ad.pdraw.app.LogoComfort";
            String defaultEditorClassName = LogoProperties.instance().getProperty("editor.default", firstEditorName);
            try {
                this.fDefaultEditor = (Editor)Class.forName(defaultEditorClassName).newInstance();
            }
            catch (Exception e) {
                System.out.println("Default editor could not be instantiated: " + defaultEditorClassName + ". Using LogoComfort.");
            }
        }
        return this.fDefaultEditor;
    }

    public Vector getEditorInfos() {
        if (this.fEditorInfos == null) {
            this.fEditorInfos = this.readEditorInfos();
        }
        return this.fEditorInfos;
    }

    public File chooseCSVFile(Component parent, String defaultName, int dialogType) {
        LogoFileChooser fileChooser = Application.getInstance().getFileChooser();
        fileChooser.setFileSelectionMode(0);
        fileChooser.resetChoosableFileFilters();
        FileType fileType = FileType.getFileType("csv", Language.getString("dialog.fileChooser.csvFile", "Comma-separated value"), Global.getIcon("Simulation.gif"));
        fileChooser.setFileFilter(fileType);
        if (defaultName != null) {
            File modelFile = new File(defaultName);
            ((JFileChooser)fileChooser).setSelectedFile(modelFile);
        }
        fileChooser.setDialogType(dialogType);
        int rw = ((JFileChooser)fileChooser).showDialog(parent, null);
        if (rw == 0) {
            File file = fileChooser.getSelectedFile();
            String fileName = file.getName();
            if (!fileName.toLowerCase().endsWith(".csv")) {
                file = new File(file.getPath() + ".csv");
            }
            return file;
        }
        return null;
    }

    public synchronized LogoFileChooser getFileChooser() {
        while (this.fFileChooser == null) {
            try {
                this.wait();
            }
            catch (InterruptedException ie) {}
        }
        this.fFileChooser.setMultiSelectionEnabled(false);
        File currentDirectory = this.fFileChooser.getCurrentDirectory();
        if (currentDirectory != null) {
            while (currentDirectory.getParentFile() != null) {
                currentDirectory = currentDirectory.getParentFile();
            }
            String absolutePath = currentDirectory.getAbsolutePath();
            if (FileSystemView.getFileSystemView().isFloppyDrive(currentDirectory) || absolutePath.toUpperCase().startsWith("A:\\") || absolutePath.toUpperCase().startsWith("B:\\")) {
                this.fFileChooser.setCurrentDirectory(null);
            }
        }
        return this.fFileChooser;
    }

    public synchronized void createFileChooser() {
        LogoFileChooser logoFileChooser = new LogoFileChooser();
        logoFileChooser.setDialogSize(new Dimension(630, 400));
        String lastDir = LogoProperties.instance().getProperty("openSaveDir");
        if (lastDir != null) {
            logoFileChooser.setCurrentDirectory(new File(lastDir));
        }
        logoFileChooser.setDragEnabled(true);
        this.fFileChooser = logoFileChooser;
        this.notifyAll();
    }

    public static Image getIconImage() {
        return Global.getImage("ApplicationIcon.gif");
    }

    public static Application getInstance() {
        if (fSingletonInstance == null) {
            fSingletonInstance = new Application();
        }
        return fSingletonInstance;
    }

    public MDIManager getMdiManager() {
        if (this.fMdiManager == null) {
            String managerClassName = LogoProperties.instance().getProperty("mdiManager", "DE.siemens.ad.logo.app.TabbedPaneMDIManager");
            try {
                MDIManager manager = (MDIManager)Class.forName(managerClassName).newInstance();
                this.setMdiManager(manager);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.fMdiManager;
    }

    public ActionGroup getMenuActionGroup() {
        ActionGroup toolbarGroup = this.getMenuManager().buildMenuActionGroup(null);
        return this.getMdiManager().getMenuManager().buildMenuActionGroup(toolbarGroup);
    }

    public MenuManager getMenuManager() {
        if (this.fMenuManager == null) {
            this.fMenuManager = new ApplicationMenuManager(this);
        }
        return this.fMenuManager;
    }

    public static String getName() {
        String s = Language.getString("app.name.long", "LOGO!Soft Comfort") + " " + Version.getCurrentVersion().getApplicationExtension();
        return s;
    }

    public ActionGroup getToolbarActionGroup() {
        ActionGroup toolbarGroup = this.getMenuManager().buildToolBarActionGroup(null);
        return this.getMdiManager().getMenuManager().buildToolBarActionGroup(toolbarGroup);
    }

    public Window getWindow() {
        return this.getActiveApplicationSurface().getWindow();
    }

    public static void main(String[] args) {
        if (LogoProperties.instance().getProperty("language", "unknown").equals("zh_CN")) {
            UIManager.put("Label.font", new Font("SansSerif", 0, 12));
            System.out.println("Set font to: SansSerif");
        }
        if (LogoProperties.instance().getProperty("language", "unknown").equals("ja_JP")) {
            UIManager.put("Label.font", new Font("SansSerif", 0, 12));
            System.out.println("Set font to: SansSerif");
        }
        new Application();
        if (args.length > 0) {
            AutoOpenFileThread.openFile(new File(args[0]));
            AutoOpenFileThread.finish();
        } else {
            LogoProperties props = LogoProperties.instance();
            if (props.getBooleanProperty(OPEN_FILE_ON_START_KEY, true)) {
                File file = null;
                int i = 0;
                String fileName = props.getProperty(OPEN_FILE_KEY + i++);
                while (fileName != null) {
                    file = new File(fileName);
                    if (file.exists()) {
                        AutoOpenFileThread.openFile(file);
                    }
                    fileName = props.getProperty(OPEN_FILE_KEY + i++);
                }
                AutoOpenFileThread.finish();
            }
        }
    }

    public boolean newDocument(EditorInfo editorInfo) {
        View view = null;
        view = this.createView(editorInfo.getEditorClassName());
        if (view != null) {
            this.addDocument(view);
        }
        return false;
    }

    public boolean newDocument() {
        View view = null;
        view = this.createView(this.getDefaultEditor().getClass().getName());
        if (view != null) {
            this.addDocument(view);
            view.getEditor().endNew();
        }
        return false;
    }

    public boolean loadDocument(File document) {
        if (document.getName().toLowerCase().endsWith(".luf")) {
            this.installUpdate(document);
            return false;
        }
        for (View view : this.getMdiManager().getViews()) {
            if (!document.getPath().equalsIgnoreCase(view.getModel().getFile().getPath())) continue;
            this.fMdiManager.changeToView(view);
            return true;
        }
        Editor editor = this.findEditor(document);
        if (editor != null) {
            ProgressIndicator progressFrame = new ProgressIndicator(this.getActiveApplicationSurface().getWindow());
            progressFrame.setTitle(Language.getString("msg.loadTitle", "Load"));
            progressFrame.setNote(document.getPath());
            progressFrame.setVisible(true);
            View view = editor.loadDocument(document, progressFrame);
            progressFrame.dispose();
            if (view != null) {
                Model model = view.getModel();
                if (editor.getEditorInfo().getDefaultFileType().accept(document)) {
                    model.setFile(document);
                } else {
                    model.setFile(new UntitledFile(Util.stripFileExtension(document.getName())));
                }
                model.setModified(false);
                this.addDocument(editor.getView());
                OpenNamedDocumentAction openNamed = new OpenNamedDocumentAction();
                openNamed.setDocument(document);
                openNamed.setOwner(Application.getInstance());
                ((ApplicationMenuManager)this.getMenuManager()).getFileHistoryGroup().addAction(openNamed);
                LogoDrawing ld = (LogoDrawing)((LogoComfort)editor).drawing();
                ld.configComments();
                this.loadDefaultFonts();
                WiringDiagram wd = ld.getWiringDiagram();
                Hardware hw = wd.getHardware();
                if (hw.supports("UDF")) {
                    ld.updateUDFBlockState(false);
                }
                return true;
            }
        } else {
            String message = Language.getString("msg.unknownFiletype", "Sorry, no editor for this filetype.", Util.getFileExtension(document.getName()));
            String title = Language.getString("msg.loadTitle", "Load file");
            JOptionPane.showMessageDialog(this.getActiveApplicationSurface(), message, title, 1);
        }
        return false;
    }

    private void installUpdate(File lufFile) {
        UpdateWizardModel updateWizardModel = new UpdateWizardModel();
        updateWizardModel.setUpdateMode(1);
        Vector<File> files = new Vector<File>(1);
        files.add(lufFile);
        SelectUpdateDirectoryModel selectUpdateDirectoryModel = new SelectUpdateDirectoryModel(updateWizardModel);
        Vector modules = selectUpdateDirectoryModel.getModules(files);
        try {
            updateWizardModel.setURL(lufFile.getParentFile().toURI().toURL().toString());
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.getWindow(), e, Language.getString("wizard.update.updateInfoPanel.title", "Updatecenter"), 0);
            return;
        }
        if (modules.isEmpty()) {
            JOptionPane.showMessageDialog(this.getWindow(), Language.getString("wizard.update.selectUpdateFilesPanel.error.invalidVersion", "The selected update is not determined for the current version of your software."), Language.getString("wizard.update.updateInfoPanel.title", "Updatecenter"), 0);
            return;
        }
        updateWizardModel.setAvailableModules(modules);
        updateWizardModel.setStartPanelModel(new SelectModulesModel(updateWizardModel));
        WizardDialog wd = WizardDialog.createWizardDialog(this.getWindow(), true);
        wd.setWizardModel(updateWizardModel);
        wd.showWizardDialog();
    }

    protected Vector readEditorInfos() {
        Vector infos = null;
        URL editorInfo = this.getClass().getResource("editorinfo.dat");
        if (editorInfo != null) {
            try {
                FileInputStream fis = new FileInputStream(editorInfo.getFile());
                StorableInput si = new StorableInput(fis);
                infos = si.readVector();
                fis.close();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (infos == null) {
            infos = new Vector();
            FupEditorInfo fupEditorInfo = new FupEditorInfo();
            KopEditorInfo kopEditorInfo = new KopEditorInfo();
            UDFEditorInfo macroEditorInfo = new UDFEditorInfo();
            infos.add(fupEditorInfo);
            infos.add(kopEditorInfo);
            infos.add(macroEditorInfo);
        }
        return infos;
    }

    public int saveDocument(View view) {
        int rw = 0;
        File modelFile = view.getModel().getFile();
        if (modelFile instanceof UntitledFile) {
            rw = this.saveDocumentAs(view);
            return rw;
        }
        if (!modelFile.canWrite()) {
            JOptionPane.showMessageDialog(this.getActiveApplicationSurface(), Language.getString("msg.writeProtection", "This file is write-protected.\nPlease choose another name."), Application.getName(), 1);
            rw = this.saveDocumentAs(view);
            return rw;
        }
        this.saveDocument(view, modelFile);
        return rw;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int saveDocument(View view, File file) {
        String errorMsg = null;
        String errorLog = null;
        boolean sameExtension = Util.getFileExtension(view.getModel().getFile().getAbsolutePath().toLowerCase()).equals(Util.getFileExtension(file.getAbsolutePath()).toLowerCase());
        ProgressIndicator progressIndicator = new ProgressIndicator(this.getWindow(), Language.getString("msg.saveTitle", "Save"));
        try {
            view.getEditor().saveDocument(file, progressIndicator);
            if (view.getEditor().getEditorInfo().getDefaultFileType().accept(file) || sameExtension) {
                view.getModel().setFile(file);
                view.getModel().setModified(false);
                OpenNamedDocumentAction openNamed = new OpenNamedDocumentAction();
                openNamed.putValue("Name", file.getPath());
                openNamed.setDocument(file);
                openNamed.setOwner(Application.getInstance());
                ((ApplicationMenuManager)this.getMenuManager()).getFileHistoryGroup().addAction(openNamed);
            }
        }
        catch (FileNotFoundException e) {
            errorMsg = errorLog = Language.getString("error.saveFile", "Error saving file: ") + "\n" + e.getMessage();
        }
        catch (IOException e) {
            e.printStackTrace();
            errorMsg = errorLog = Language.getString("error.saveFile", "Error saving file: ") + "\n" + e.getMessage();
        }
        catch (ProgramException e) {
            String s;
            errorMsg = e.getUser();
            errorLog = e.get("logOutput");
            if (errorLog == null) {
                errorLog = errorMsg;
            }
            if ((s = e.getExpert()) != null) {
                System.out.println(s);
            }
        }
        catch (Exception e) {
            errorMsg = errorLog = "Exception: " + e;
            e.printStackTrace();
        }
        finally {
            progressIndicator.dispose();
        }
        if (errorMsg != null) {
            Log.println(errorLog);
            view.getEditor().getStatusLine().setText(errorMsg);
            new LogoError(this.getActiveApplicationSurface(), errorMsg).display();
            return 2;
        }
        return 0;
    }

    public int saveDocumentAs(View view) {
        boolean fileNameCorrect;
        int rw = 0;
        LogoFileChooser fileChooser = this.getFileChooser();
        fileChooser.setFileSelectionMode(0);
        fileChooser.setFileView(new LogoFileView(view.getEditor().getEditorInfo().getStorableFileTypes()));
        fileChooser.resetChoosableFileFilters();
        Iterator fileTypes = view.getEditor().getEditorInfo().getStorableFileTypes().iterator();
        FileType fileType = null;
        while (fileTypes.hasNext()) {
            fileType = (FileType)fileTypes.next();
            ((JFileChooser)fileChooser).addChoosableFileFilter(fileType);
        }
        fileChooser.setFileFilter(view.getEditor().getEditorInfo().getDefaultFileType());
        File modelFile = view.getModel().getFile();
        if (modelFile.getName().indexOf(".") != -1) {
            modelFile = new File(modelFile.getAbsolutePath().substring(0, modelFile.getAbsolutePath().lastIndexOf(".")));
        }
        ((JFileChooser)fileChooser).setSelectedFile(modelFile);
        File selectedFile = null;
        do {
            fileNameCorrect = true;
            rw = fileChooser.showSaveDialog(this.getActiveApplicationSurface());
            selectedFile = fileChooser.getSelectedFile();
            if (rw == 1 || selectedFile == null) {
                return rw;
            }
            String fileName = selectedFile.getName();
            if (fileName.indexOf(".") == -1 || !this.checkExtensionExist(fileName, view)) {
                FileType saveFileType = null;
                saveFileType = fileChooser.getFileFilter() instanceof FileType ? (FileType)fileChooser.getFileFilter() : view.getEditor().getEditorInfo().getDefaultFileType();
                selectedFile = new File(selectedFile.getPath() + "." + saveFileType.getExtension());
            }
            if (selectedFile.exists() && !selectedFile.equals(view.getModel().getFile())) {
                int overwriteRw = JOptionPane.showConfirmDialog(this.getActiveApplicationSurface(), Language.getString("msg.overwriteDocument", "File '%' already exists. Overwrite it?", selectedFile.getName()), Application.getName(), 1);
                if (overwriteRw == 2) {
                    return 1;
                }
                if (overwriteRw == 1) {
                    fileNameCorrect = false;
                }
            }
            if (!fileNameCorrect || !selectedFile.exists() || selectedFile.canWrite()) continue;
            fileNameCorrect = false;
            JOptionPane.showMessageDialog(this.getActiveApplicationSurface(), Language.getString("msg.writeAsProtection", "A write protected file with the same name exists. \nPlease choose another name."), Language.getString("app.name.long", "LOGO!Soft Comfort"), 1);
        } while (!fileNameCorrect);
        try {
            if (view instanceof LogoDrawingViewUDF) {
                UDFBlock udf = ((WiringDiagramUDF)((LogoDrawingUDF)((LogoDrawingViewUDF)view).drawing()).getWiringDiagram()).getUDFBlock();
                GuidVersionMgr mgr = new GuidVersionMgr(System.currentTimeMillis());
                udf.setGuidManager(mgr);
            }
            this.saveDocument(view, selectedFile);
            if (view.getEditor().getEditorInfo().getDefaultFileType().accept(selectedFile)) {
                view.getModel().setFile(selectedFile);
            }
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this.getActiveApplicationSurface(), exception, "Error", 0);
        }
        return rw;
    }

    public void setDefaultEditor(EditorInfo editorInfo) {
        this.fDefaultEditor = this.createEditor(editorInfo.getEditorClassName());
        LogoProperties.instance().setProperty("editor.default", editorInfo.getEditorClassName());
    }

    public void setMdiManager(MDIManager newMdiManager) {
        if (this.fMdiManager != null) {
            Vector views = new Vector(this.fMdiManager.getViews());
            View activeView = this.fMdiManager.getActiveTopLevelView();
            Enumeration e = views.elements();
            View view = null;
            while (e.hasMoreElements()) {
                view = (View)e.nextElement();
                this.fMdiManager.removeView(view);
            }
            this.fMdiManager.close();
            newMdiManager.setApplication(this);
            newMdiManager.open();
            this.fMdiManager = newMdiManager;
            ((MDIMenuManager)newMdiManager.getMenuManager()).init();
            newMdiManager.getApplicationSurface().setEditor(null);
            this.getActiveApplicationSurface().validate();
            e = views.elements();
            while (e.hasMoreElements()) {
                view = (View)e.nextElement();
                this.fMdiManager.addView(view);
                WiringDiagram wd = ((LogoDrawing)view.getModel()).getWiringDiagram();
                if (wd.getNetworkInfo().getIPAddress().equals("") || !(((LogoComfort)view.getEditor()).tool() instanceof SimulationTool)) continue;
                this.fMdiManager.updateSimulatedViewTitle(view);
            }
            this.fMdiManager.changeToView(activeView);
            LogoAction action = this.getMenuActionGroup().getAction(CascadeAction.class);
            if (action != null) {
                action.doIt();
            }
            LogoProperties.instance().setProperty("mdiManager", this.fMdiManager.getClass().getName());
        } else {
            this.fMdiManager = newMdiManager;
            newMdiManager.setApplication(this);
            newMdiManager.open();
            String FIRST_START = "app.firstStart";
            LogoProperties logoProperties = LogoProperties.instance();
            if (logoProperties.getProperty("app.firstStart", true)) {
                ShowHelpContextAction action = new ShowHelpContextAction();
                action.setHelpID(Global.FIRST_START_HELP_SCREEN);
                action.setActivationWindow((JDialog)SwingUtilities.getAncestorOfClass(JDialog.class, newMdiManager.getApplicationSurface()));
                action.doIt();
                logoProperties.setBooleanProperty("app.firstStart", false);
            }
        }
    }

    public void showAbout() {
        AboutPanel aboutPanel = new AboutPanel();
        SplittedDlg dialog = SplittedDlg.create(this.getActiveApplicationSurface().getWindow(), aboutPanel, 1);
        dialog.show();
    }

    public void showHelp() {
        Runtime runtime = Runtime.getRuntime();
        String[] cmdArr = new String[2];
        try {
            String language;
            cmdArr[0] = LogoProperties.instance().getProperty("logo.helpApplication", "");
            if (cmdArr[0] == "") {
                cmdArr[0] = "Start.exe";
            }
            if ((language = LogoProperties.instance().getProperty("language")) != null) {
                cmdArr[1] = "Language_" + language.substring(0, 2) + ".pdf";
            } else {
                System.out.println("Error starting .pdf: LanguageProperty not found");
            }
            cHelpProcess = runtime.exec(cmdArr);
        }
        catch (Exception e) {
            System.out.println(e);
            GetFileNamePanel fileNamePanel = new GetFileNamePanel((JFrame)this.getActiveApplicationSurface().getWindow());
            SplittedDlg dialog = SplittedDlg.create(this.getActiveApplicationSurface().getWindow(), fileNamePanel, 11);
            dialog.show();
            cmdArr[0] = System.getProperty("logo.helpApplication", "AcroRd32.exe");
            try {
                cHelpProcess = runtime.exec(cmdArr);
            }
            catch (Exception e2) {
                cHelpProcess = null;
            }
        }
    }

    public UpdateWizardModel getUpdateWizardModel() {
        return this.fUpdateWizardModel;
    }

    public void setUpdateWizardModel(UpdateWizardModel updateWizardModel) {
        this.fUpdateWizardModel = updateWizardModel;
    }

    private boolean checkExtensionExist(String fileName, View view) {
        if (fileName.indexOf(".") != -1) {
            if ((fileName = fileName.toLowerCase()).endsWith(".hex")) {
                return true;
            }
            if (fileName.endsWith(".svg")) {
                return true;
            }
            if (fileName.endsWith(".pcx")) {
                return true;
            }
            if (fileName.endsWith(".xml")) {
                return true;
            }
            for (FileType fileType : view.getEditor().getEditorInfo().getStorableFileTypes()) {
                if (!fileName.endsWith("." + fileType.getExtension().toLowerCase())) continue;
                return true;
            }
        }
        return false;
    }

    private void loadDefaultFonts() {
        LogoProperties properties = LogoProperties.instance();
        TextFigure.setCurrentFontStyle(properties.getIntProperty("font.default.style", 0));
        TextFigure.setCurrentFontSize(properties.getIntProperty("font.default.size", 12));
        TextFigure.setCurrentFontName(properties.getProperty("font.default.name", "Dialog"));
        TextFigure.setCurrentFontColor(new Color(properties.getIntProperty("font.default.color", -16777216)));
    }

    static {
        try {
            try {
                long time = 0L;
                new LookAndFeelLoader().loadAvailableLookAndFeel();
                String lafClassName = LogoProperties.instance().getProperty("app.laf", "DE.siemens.ad.logo.app.plaf.ExtendedWindowsLookAndFeel");
                LookAndFeel lookAndFeel = (LookAndFeel)Class.forName(lafClassName).newInstance();
                UIManager.setLookAndFeel(lookAndFeel);
                PopupFactory.setSharedInstance(new PopupFactory());
            }
            catch (Exception e) {
                UIManager.setLookAndFeel(new MetalLookAndFeel());
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }
}

